function [savetype] = vb_meginfo_get_savetype(meginfo)
% return saving type channel data or trial one
% [usage]
%   [save_type] = vb_meginfo_get_savetype(meginfo)
% [input]
%   meginfo : <required> <<struct>> MEG information
% [output]
%   savetype : 0) channel data file (*.ch.meg.dat)
%            : 1) trial data file (*.tr.meg.dat)
% [note]
%   determine by acq_type field (MEGinfo.device_info)
%   'Continuous_Raw' ---> channel type
%   'Evoked_Ave' -------> channel type
%   'Evoked_Raw' -------> channel type
%
%    Deprecated (not be used)
%
% [history]
%   2008-02-22 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
savetype = 0;
return;

%{
func_ = mfilename;

vb_define_device;

acq_type = vb_meginfo_get_acqtype(meginfo);

if strcmp(acq_type, MEG_ACQTYPE_CON_RAW)
  savetype = 0;  % channel type
elseif strcmp(acq_type, MEG_ACQTYPE_EVO_AVE)
  savetype = 0;  % trial type
elseif strcmp(acq_type, MEG_ACQTYPE_EVO_RAW)
  savetype = 0;  % trial type
else
  error('(%s)unexpected acq_type : %s', func_, acq_type);
end
%}
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo] = inner_check_arguments(meginfo)
func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(vb_meginfo_get_acqtype(meginfo))
  error('(%s)MEGinfo does not have acquisition type field', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
