function [meg2mri] = vb_meginfo_get_meg2mri(meg_info)
% return matrix that is to be 'meg to mri'
% [usage]
%   [meg2mri] = vb_meginfo_get_meg2mri(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo which is expected to have
%            :  matching_info
% [output]
%    meg2mri : [4 x 4] ? matrix to transform
% [note]
%    if you are YOKOGAWA user, the matching_info is loaded from YOKOGAWA file
%    this function is made for only YOKOGAWA for now
% [history]
%   2008-02-07 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isfield(meg_info.matching_info, 'meg_to_mri')
  meg2mri = meg_info.matching_info.meg_to_mri;
else
  meg2mri = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end

if ~isfield(meg_info, 'matching_info')
  meg_info.matching_info = [];
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%

