function [acq_info] = vb_meginfo_get_acqinfo(meg_info)
% return acq_info from MEGinfo
% [usage]
%   [acq_info] = vb_meginfo_get_acqinfo(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo struct
% [output]
%   acq_info : acq_info struct obtained from MEGinfo
% [note]
%   The new format was defind. (2011-05)
% [history]
%   2011-05-26 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
acq_info = [];

if isfield(meg_info, 'device_info')
  if isfield(meg_info.device_info, 'acq_info')
    acq_info = meg_info.device_info.acq_info;
  else
%     warning('device_info does not have ''acq_info'' field\n');
  end
else
  % --- compatible with old style
  if isfield(meg_info, 'acq_info')
    acq_info = meg_info.acq_info;
  else
%     warning('meg_info does not have ''acq_info'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s) meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
