function [MEGinfo] = vb_meginfo_convert_raw2vbmeg(raw_info)
% make MEGinfo struct by picking up data from raw information
%
% [usage]
%   [MEGinfo] = vb_meginfo_convert_raw2vbmeg(raw_info)
%
% [input]
%   raw_info : <required> <<struct>> raw information
%
% [output]
%    MEGinfo : <<struct>> MEGinfo
%
% [note]
%
% [history]
%   2007-07-10 (Sako) initial version
%   2007-08-22 (Sako) remove temporary field of saveman
%   2008-01-31 (Sako) renewed due to new specification
%   2008-04-23 (Sako) added ActiveChannel and ActiveTrial
%   2011-02-17 (Sako) delete checking temporary field of saveman
%   2011-05-26 (Sako) some fields were moved to device_info
%   2011-07-21 (Sako) modified how to deal with sensor_weight_ref
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('raw_info', 'var'), raw_info = []; end
[raw_info] = inner_check_arguments(raw_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% MEGinfo.device            % device name
% MEGinfo.sensor_weight     % coil weight
% MEGinfo.Nchannel          % number of active gardiometers
% MEGinfo.Nsample           % number of sample
% MEGinfo.Pretrigger        % number of sample before trigger
% MEGinfo.SampleFreq        % sampling frequency
% MEGinfo.Nrepeat           % number of trial
% MEGinfo.Trial             % <<struct>> trial information
%                           %  .number : trial index number
%                           %  .sample : sample list of this trial
% MEGinfo.MEGch_id          % Active MEG channel index
% MEGinfo.MEGch_name        % Active MEG channel name
% MEGinfo.MEG_ID            % MEG filename(no extention)
% MEGinfo.MRI_ID            % MRI hash key
% MEGinfo.Vcenter           % origin of sphere model [m]
% MEGinfo.ExtraChannelInfo  % information struct of eeg in MEG
% MEGinfo.ActiveChannel     % active channel flag list
% MEGinfo.ActiveTrial       % active trial flag list
%
% MEGinfo.device_info.sensor_weight_ref % coil weight

MEGinfo.device        = raw_info.device;
MEGinfo.sensor_weight = raw_info.sensor_weight;
MEGinfo.Nchannel      = raw_info.Nchannel;
MEGinfo.Nsample       = raw_info.Nsample;

pretrigger = vb_meginfo_get_pre_trigger(raw_info);
MEGinfo = vb_meginfo_set_pre_trigger(MEGinfo, pretrigger);

MEGinfo.SampleFreq    = raw_info.SampleFreq;
MEGinfo.Nrepeat       = raw_info.Nrepeat;

MEGinfo.Trial         = raw_info.Trial;

MEGinfo.MEGch_id      = raw_info.MEGch_id;
MEGinfo.MEGch_name    = raw_info.MEGch_name;
MEGinfo.MEG_ID        = raw_info.MEG_ID;
MEGinfo.MRI_ID        = raw_info.MRI_ID;
MEGinfo.Vcenter       = raw_info.Vcenter;
MEGinfo.Vradius       = raw_info.Vradius;

% --- added ActiveChannel
MEGinfo = ...
  vb_info_set_active_channel(MEGinfo, vb_info_get_active_channel(raw_info));

% --- added ActiveTrial
active_trial_flag = ones(length(MEGinfo.Trial),1);
MEGinfo = vb_info_set_active_trial(MEGinfo, active_trial_flag);

% --- added ChannelInfo (temporarily)
MEGinfo.ChannelInfo = raw_info.ChannelInfo;

MEGinfo.saveman       = raw_info.saveman;

MEGinfo.ExtraChannelInfo = raw_info.ExtraChannelInfo;

% ----- device dependent fields
%
% MEGinfo.device_info       % device dependent data struct
%                           %   .sensor_weight_ref
%                           %   .acq_type
%                           %   .acq_info
%                           %   .TransInfo
%
% device_info.sensor_weight_ref
%
% device_info.acq_type      % data acquisition type
% device_info.acq_info      % data acquisition information
%                           %   .data_file
%                           %   .type
%                           %   .data_bit_len
% device_info.TransInfo     % transform coordinate information
%
MEGinfo = vb_meginfo_set_sensor_weight_refmg(MEGinfo,  ...
  vb_meginfo_get_sensor_weight_refmg(raw_info));

MEGinfo = vb_meginfo_set_acqtype(MEGinfo, ...
            vb_meginfo_get_acqtype(raw_info));

MEGinfo = vb_meginfo_set_acqinfo(MEGinfo, ...
            vb_meginfo_get_acqinfo(raw_info));

MEGinfo = vb_info_set_transinfo(MEGinfo, ...
            vb_info_get_transinfo(raw_info));
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [raw_info] = inner_check_arguments(raw_info)
func_ = mfilename;
if isempty(raw_info)
  error('(%s)raw_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
