function [result] = vb_megfile_is_before_05b(megfile)
% check megfile version before 0.5b or after
% [usage]
%   [result] = vb_megfile_is_before_05b(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%    result : <<boolean>>
%           :   true ) meg.mat file before 0.5b
%           :  false ) meg.mat file after 0.5b
% [note]
%   exceptional) the case that this megfile was made without pos-mat file
% [history]
%   2009-04-16 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = ''; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo = vb_megfile_load_meginfo(megfile);
transinfo = vb_info_get_transinfo(meginfo);

if isempty(transinfo)

  load(megfile, 'CoordType');
  if ~exist('CoordType', 'var')
    fprintf('(05b_OR_BEFORE) this megfile may be made without pos-mat file\n');
    result = true;
    return;
  else
    fprintf('(AFTER_06_A) coordinate type is %s\n', CoordType);
    result = false;
    return;
  end

else
  fprintf('(AFTER_06_A) I found MEGinfo.TransInfo\n');
  result = false;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  error('(%s) megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s) cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
