function vb_megfile_import_extra_data(megfile, extdata, ch_info, ow_flag, newfile)
% import extra data to a megfile
% [usage]
%   vb_megfile_import_extra_data(megfile, extdata, ch_info, ow_flag, newfile)
% [input]
%  megfile : <required> MEG-MAT file for base
%  extdata : <required> extra data which will be appended as extra channel data
%          :  [n_channel x n_sample x n_trial]
%  ch_info : <required> <<struct>> ChannelInfo type struct
%          :  the fields of which are as follows.
%          :  .Active <optional> [n_channel x 1 boolean] [1]
%          :  .Name   <required> {n_channel x 1 cell} - must be unique
%          :  .Type   <optional> [n_channel x 1 double]  [-999]
%          :  You can make sure defined 'TYPES' in [note].
%  ow_flag : <optional> overwrite flag
%          :  [0]) overlapped ID data will not be overwritten
%          :   1 ) overlapped ID data will be forcely overwritten
%  newfile : <optional> file to be saved updated data [megfile]
%          :  -notice- If this is not given, megfile will be overwritten.
% [output]
%   none
% [note]
%   defined channel types:
%     0) Null Channel
%     1) MagnetoMeter
%     2) AxialGradioMeter
%     3) PlannarGradioMeter
%    -1) TriggerChannel
%    -2) EegChannel
%    -3) EcgChannel
%    -4) EtcChannel
%   Extra channels' ID are automatically determined.
% [history]
%   2010-06-17 (Sako) initial version
%   2011-02-17 (Sako) changed how to call vb_saveman_get_dir
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = ''; end
if ~exist('extdata', 'var'), extdata = []; end
if ~exist('ch_info', 'var'), ch_info = []; end
if ~exist('ow_flag', 'var'), ow_flag = []; end
if ~exist('newfile', 'var'), newfile = ''; end
[megfile, extdata, ch_info, ow_flag, newfile] = ...
  inner_check_arguments(megfile, extdata, ch_info, ow_flag, newfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

org_info = vb_load_measurement_info(megfile);
n_sp_org = vb_info_get_sample_number(org_info);
n_tr_org = vb_info_get_trial_number(org_info);

[n_ch_ext, n_sp_ext, n_tr_ext] = size(extdata);

% --- confirm whether extdata is valid or not
if n_sp_org ~= n_sp_ext
  error('(%s) number of sample must be the same (%d, %d)', ...
    func_, n_sp_org, n_sp_ext);
end

if n_tr_org ~= n_tr_ext
  error('(%s) number of trial must be the same (%d, %d)', ...
    func_, n_tr_org, n_tr_ext);
end

% --- overlap test
% ----- Name
idx_name_meg = [];
idx_name_ext = [];

% ------- MEG Channel
org_meg_name_list = org_info.MEGch_name;
if ~isempty(org_meg_name_list)
  [result_name_meg, idx_name_meg] = vb_util_check_string_lists( ...
    org_meg_name_list, ch_info.Name);

  if ~isempty(idx_name_meg) && ow_flag == 0
    for i_ch = 1:length(idx_name_meg)
      fprintf('(%s)', org_meg_name_list{idx_name_meg(i_ch)});
    end
    error('(%s) some ch_info.Name has been always used', func_);
  end
end

% ------- Extra Channel
org_ext_name_list = org_info.ExtraChannelInfo.Channel_name;
if ~isempty(org_ext_name_list)
  [result_name_ext, idx_name_ext] = vb_util_check_string_lists( ...
    org_ext_name_list, ch_info.Name);

  if ~isempty(idx_name_ext) && ow_flag == 0
    for i_ch = 1:length(idx_name_ext)
      fprintf('(%s)', org_ext_name_list{idx_name_ext(i_ch)});
    end
    error('(%s) some ch_info.Name has been always used', func_);
  end
end

if isempty(idx_name_meg) && isempty(idx_name_ext) ...
  % force ow_flag to set 0 and extdata would be added as ExtraChannel Data
  ow_flag = 0;
end

% --- load original whole data
org_data = load(megfile);
const = vb_define_yokogawa;
data_dir = vb_saveman_get_dir(org_info.saveman);


if ow_flag == 0
  % --- not be allowed to overwrite
  % --- update ExtraChannelInfo
  [org_ext_info] = inner_update_extra_ch_info(org_data.MEGinfo, ch_info);
  
%   org_ext_info = org_data.MEGinfo.ExtraChannelInfo;
%   n_ch_org = size(org_ext_info.Channel_active, 1);
% 
%   % --- resolve new ch_info.ID
%   if ~isempty(org_ext_info.Channel_id)
%     last_ch_id_org = max(org_ext_info.Channel_id);
%   elseif ~isempty(org_data.MEGinfo.MEGch_id)
%     last_ch_id_org = max(org_data.MEGinfo.MEGch_id);
%   else
%     last_ch_id_org = 0;
%   end
%   ch_info.ID = [];
%   
%   next_ch_id = last_ch_id_org + 1;
%   for i_ch = 1:n_ch_ext
%     ch_info.ID = [ch_info.ID; next_ch_id];
%     next_ch_id = next_ch_id + 1;
%   end
%   
%   org_ext_info.Channel_active = [org_ext_info.Channel_active; ch_info.Active];
%   org_ext_info.Channel_type   = [org_ext_info.Channel_type;   ch_info.Type];
%   org_ext_info.Channel_id     = [org_ext_info.Channel_id;     ch_info.ID];
% 
%   for i_ch = 1:n_ch_ext
%     org_ext_info.Channel_name{n_ch_org+i_ch} = ch_info.Name{i_ch};
%   end
% 
%   if n_ch_org == 0
%     org_ext_info.Channel_name = org_ext_info.Channel_name';
%   end

  org_data.MEGinfo.ExtraChannelInfo = org_ext_info;

  % ----- check internal data
  if inner_is_stored_externally(megfile)

    % store externally
    f_path = vb_get_file_parts(newfile);
    PRECISION = vb_meginfo_get_precision(org_info);

    for i_ch = 1:n_ch_ext
      inner_make_external_data_file( ...
        f_path, data_dir, ch_info.Name{i_ch}, const.EXT_CHANNEL_BIN, ...
        PRECISION, extdata(i_ch,:,:));
    end

  else
    % store internally
    for i_ch = 1:n_ch_ext
      org_data.bexp_ext = [org_data.bexp_ext; extdata(i_ch,:,:)];
    end
  end

% ---------------------------------------------------------------------------- %
else
  % --- overwritable

  % ----- devide ch_info into next 3 types
  ch_info_idx_meg = [];
  ch_info_idx_ext = [];
  ch_info_idx_new = [];
  
  info = [];
  if ~isempty(idx_name_meg)
    % --- MEG channel data
    ow_name = org_meg_name_list(idx_name_meg);
 
    % --- get index of ch_info
    [res_tmp, idx_ext] = vb_util_check_string_lists(ch_info.Name, ow_name);
    ch_info_idx_meg = idx_ext;
    
    % --- update Actve Channel and Type
    info = org_data.MEGinfo;
    for i_ch = 1:length(idx_name_meg)
      idx_org = idx_name_meg(i_ch);
      idx_new = idx_ext(i_ch);
      info.ActiveChannel(idx_org)      = ch_info.Active(idx_new);
      info.ChannelInfo.Active(idx_org) = ch_info.Active(idx_new);
      info.ChannelInfo.Type(idx_org)   = ch_info.Type(idx_new);
    end
  end
  % --- update MEGinfo
  if ~isempty(info)
    org_data.MEGinfo = info;
    info = [];
  end
  
  if ~isempty(idx_name_ext)
    % --- MEG channel data
    ow_name = org_ext_name_list(idx_name_ext);

    % --- get index of ch_info
    [res_tmp, idx_ext] = vb_util_check_string_lists(ch_info.Name, ow_name);
    ch_info_idx_ext = idx_ext;

    % --- update Actve Channel and Type
    info = org_data.MEGinfo.ExtraChannelInfo;
    for i_ch = 1:length(idx_name_ext)
      idx_org = idx_name_ext(i_ch);
      idx_new = idx_ext(i_ch);
      info.Channel_active(idx_org) = ch_info.Active(idx_new);
      info.Channel_type(idx_org)   = ch_info.Type(idx_new);
    end
  end
  % --- update MEGinfo.ExtraChannelInfo
  if ~isempty(info)
    org_data.MEGinfo.ExtraChannelInfo = info;
    info = [];
  end
  
  % --- check whether undefined name channels are given or not
  whole_list = [org_meg_name_list; org_ext_name_list];
  [new_list, idx] = vb_util_omit_list(ch_info.Name, whole_list);
  ch_info_idx_new = idx;
  
  cur_ch_info.Name   = new_list;
  cur_ch_info.Active = ch_info.Active(idx);
  cur_ch_info.Type   = ch_info.Type(idx);
  
  [ext_info] = inner_update_extra_ch_info(org_data.MEGinfo, cur_ch_info);
  org_data.MEGinfo.ExtraChannelInfo = ext_info;
  
  % --- update data
  if inner_is_stored_externally(megfile)

    % --- store externally
    f_path = vb_get_file_parts(newfile);
    PRECISION = vb_meginfo_get_precision(org_info);

    for i_ch = 1:n_ch_ext
      inner_make_external_data_file( ...
        f_path, data_dir, ch_info.Name{i_ch}, const.EXT_CHANNEL_BIN, ...
        PRECISION, extdata(i_ch,:,:));
    end

  else
    % --- store internally
    if ~isempty(ch_info_idx_meg)
      % --- replace
      org_data.bexp(idx_name_meg,:,:) = extdata(ch_info_idx_meg,:,:);
    end
    
    if ~isempty(ch_info_idx_ext)
      % --- replace
      org_data.bexp_ext(idx_name_ext,:,:) = extdata(ch_info_idx_ext,:,:);
    end
    
    if ~isempty(ch_info_idx_new)
      % --- append
      org_data.bexp_ext = [org_data.bexp_ext; extdata(ch_info_idx_new,:,:)];
    end
  end
end

% --- make new file
vb_save_struct(newfile, org_data);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile, extdata, ch_info, ow_flag, newfile] = ...
  inner_check_arguments(megfile, extdata, ch_info, ow_flag, newfile)

func_ = mfilename;
% --- megfile
if isempty(megfile)
  error('(%s) megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s) cannot find megfile %s', func_, megfile);
end

% --- extdata
if isempty(extdata)
  error('(%s) extdata is a required parameter', func_);
end

% --- ch_info
if isempty(ch_info)
  error('(%s) ch_info is a required parameter', func_);

elseif ~isfield(ch_info, 'Active')
  ch_info.Active = 1;

elseif ~isfield(ch_info, 'Type')
  ch_info.Type   = -9999;

elseif ~isfield(ch_info, 'Name') || isempty(ch_info.Name)
  error('(%s) Name is a required field of ch_info', func_);
end

% --- ow_flag
if isempty(ow_flag)
  ow_flag = 0;
end

% --- newfile
if isempty(newfile)
  newfile = megfile;
end
return;
%
% --- end of inner_check_arguments()

% --- inner_is_stored_externally()
%
function [result] = inner_is_stored_externally(megfile)

result = 0;

[state_bexp, guide_const] = vb_util_check_variable_in_matfile(megfile, 'bexp');
[state_bexp_ext] = vb_util_check_variable_in_matfile(megfile, 'bexp_ext');
[state_refmg] = vb_util_check_variable_in_matfile(megfile, 'refmg');

if state_bexp ~= guide_const.VALID ...
    && state_bexp_ext ~= guide_const.VALID ...
    && state_refmg ~= guide_const.VALID
  % --- this means storing externally
  result = 1;
else
  % --- this means storing internally
  result = 0;
end
return;
%
% --- end of inner_is_stored_externally()

% --- inner_make_external_data_file()
%
function inner_make_external_data_file(fpath, d_dir, fname, f_ext, prec, data)
func_ = mfilename;

ch_file = sprintf('%s/%s/%s.%s', fpath, d_dir, fname, f_ext);
fid = fopen(ch_file, 'wb');
if fid == -1
  error('(%s)cannot open file (%s)', func_, ch_file);
end

fwrite(fid, data(:), prec);
fclose(fid);
return;
%
% --- end of inner_make_external_data_file()


% --- inner_update_extra_ch_info()
%
function [new_ext_info] = inner_update_extra_ch_info(meg_info, ch_info)

ext_info = meg_info.ExtraChannelInfo;

n_ch_org = size(ext_info.Channel_active, 1);
n_ch_ext = size(ch_info.Active, 1);

% --- resolve new ch_info.ID
if ~isempty(ext_info.Channel_id)
  last_ch_id_org = max(ext_info.Channel_id);
elseif ~isempty(meg_info.MEGch_id)
  last_ch_id_org = max(meg_info.MEGch_id);
else
  last_ch_id_org = 0;
end
ch_info.ID = [];
  
next_ch_id = last_ch_id_org + 1;
for i_ch = 1:n_ch_ext
  ch_info.ID = [ch_info.ID; next_ch_id];
  next_ch_id = next_ch_id + 1;
end
  
ext_info.Channel_active = [ext_info.Channel_active; ch_info.Active];
ext_info.Channel_type   = [ext_info.Channel_type;   ch_info.Type];
ext_info.Channel_id     = [ext_info.Channel_id;     ch_info.ID];

for i_ch = 1:n_ch_ext
  ext_info.Channel_name{n_ch_org+i_ch} = ch_info.Name{i_ch};
end

if n_ch_org == 0
  ext_info.Channel_name = ext_info.Channel_name';
end

new_ext_info = ext_info;
return;
%
% --- end of inner_update_extra_ch_info()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
