function [ref_data] = vb_megfile_get_internal_data_ref(megfile)
% return refference magnetometer data which is stored on megfile
% [usage]
%   [refmg] = megfile_get_keeping_data_ref(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%  ref_data : refference magnetometer data which is stored in refmg field
%           : [Nchannel x Nsample x Ntrial]
% [note]
%   If megfile is old, it may not have 'refmg' field. Then return empty.
%   This function does not return data selected in sample or trial
% [history]
%   2008-02-19 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
load(megfile, 'refmg');

% - for old fashioned
if ~exist('refmg', 'var')
  refmg = inner_exstract_from_eeg(megfile);
end

ref_data = refmg;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;

if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()

% --- inner_extract_from_eeg()
%
function [refmg] = inner_exstract_from_eeg(megfile)
% no support
refmg = [];
return;
%
% --- end of inner_extract_from_eeg()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
