function [ch_info] = vb_megfile_get_applicable_channel(megfile, ch_list)
% return applicable channel lists of MEG/EXTRA/REFMG
% [usage]
%   [ch_info] = vb_megfile_get_applicable_channel(megfile, ch_list)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
%   ch_list : <required> channel list
% [output]
%   ch_info : <<struct>> lists of each channel
%           :   fields are as follows
%           :   .meg_channel : MEG channels in ch_list
%           :   .ext_channel : EXTRA channels in ch_list
%           :   .ref_channel : REFMG channels in ch_list
% [note]
%   if the frame of channel type is changed this function must be modified
% [history]
%   2007-07-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
if ~exist('ch_list', 'var'), ch_list = []; end
[megfile, ch_list] = inner_check_arguments(megfile, ch_list);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo = vb_megfile_load_meginfo(megfile);
org_meg_ch = vb_meginfo_get_channel_label_meg(meginfo);
org_ext_ch = vb_meginfo_get_channel_label_extra(meginfo);
org_ref_ch = vb_meginfo_get_channel_label_refmg(meginfo);

ch_info = [];

ch_info = vb_ch_info_set_channel_info_meg(ch_info, ...
            vb_util_get_overlapping_vector(org_meg_ch, ch_list));

ch_info = vb_ch_info_set_channel_info_ext(ch_info, ...
            vb_util_get_overlapping_vector(org_ext_ch, ch_list));

ch_info = vb_ch_info_set_channel_info_ref(ch_info, ...
            vb_util_get_overlapping_vector(org_ref_ch, ch_list));
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile, ch_list] = inner_check_arguments(megfile, ch_list)
func_ = mfilename;

if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if isempty(ch_list)
  error('(%s)ch_list is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
