function [pick, Qpick, MEGinfo] = ...
  vb_meg_adjust_sensor(pick, Qpick, ch_idx, MEGinfo)
% adjust sensor information according to ch_idx
%
% [usage]
%   [pick, Qpick, MEGinfo] = ...
%     vb_meg_adjust_sensor(pick, Qpick, ch_idx, MEGinfo)
%
% [input]
%      pick : <required> [Ncoil x 3] pick before adjusting
%     Qpick : <required> [Ncoil x 3] Qpick before adjusting
%    ch_idx : <required> [Nsensor_new x 1] index of valid channels
%   MEGinfo : <required> <<struct>> before sensor_weight is updated
%
% [output]
%      pick : [Ncoil_new x 3] pick after adjusting
%     Qpick : [Ncoil_new x 3] Qpick after adjusting
%   MEGinfo : <<struct>> updated sensor_weight [Nsensor_new x Ncoil_new]
%
% [note]
%   
% [history]
%   2008-04-22 (Sako) initial version
%   2009-07-13 (Sako) modified to arrange by using ch_idx
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('pick', 'var'), pick = []; end
if ~exist('Qpick', 'var'), Qpick = []; end
if ~exist('ch_idx', 'var'), ch_idx = []; end
if ~exist('MEGinfo', 'var'), MEGinfo = []; end
[pick, Qpick, ch_idx, MEGinfo] = ...
  inner_check_arguments(pick, Qpick, ch_idx, MEGinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% --- select channels
wgt = MEGinfo.sensor_weight(ch_idx,:);

% --- select sensor coils corresponding to the selected channels
jx = find(sum(abs(wgt),1) > 0);
pick = pick(jx,:);
Qpick = Qpick(jx,:);

MEGinfo.sensor_weight = MEGinfo.sensor_weight(ch_idx,jx);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [pick, Qpick, ch_idx, MEGinfo] = ...
  inner_check_arguments(pick, Qpick, ch_idx, MEGinfo)
% --- require no check for now
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
