function vb_megfile_write_pretrigger(megfile, pretrigger)
% Overwrite pretrigger of MEG data
% [usage]
%   vb_megfile_write_pretrigger(megfile, pretrigger)
% [input]
%      megfile : <required> <<file>> .meg.mat file as base and this is updated
%   pretrigger : <required> pretrigger
% [output]
%   none
% [note]
%   If the given megfile has old fashioned field name, 
%   this function replaces it with new one.
% --- History
% 2008-12-04 Taku Yoshioka
% 2010-01-19 (Sako) replaced vb_load_meg_info with vb_load_measurement_info
% 2010-01-26 (Sako) rename
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

MEGinfo = vb_load_measurement_info(megfile);
if isfield(MEGinfo,'Pretriger'), 
  MEGinfo = rmfield(MEGinfo,'Pretriger'); 
end
MEGinfo.Pretrigger = pretrigger;
vb_save(megfile,'MEGinfo');
