function vb_megfile_remove_environmental_noise(meg_file,new_meg_file,Twin_sec,smin)
% Remove environmental noise by using temporal PCA of reference sensor signal
%   
% --- Input
%   megfile : .meg.mat (including MEG and REFERENCE data)
%   new_meg_file : denoised meg file (.meg.mat) to be saved
%   Twin_sec = [Nbck , Nfwd] : time shift length for backward and forward
%   direction [sec]
%     if Twin is scalar, Nbck = Nfwd = Twin is assumed
% --- Optional Input
%   smin : >= 1 :  number of components for threshould PCA (default 40)
%           < 1  : contribution rate for threshould PCA
%
% 2008-1-25 Masa-aki Sato
% 2015-4-20 Yusuke Fujiwara
% 2015-6-12 Yusuke Takeda (Modified for pipeline of VBMEG)

% Set parameters
if length(Twin_sec)==1, Twin_sec = [Twin_sec, Twin_sec]; end;
if length(Twin_sec)>2, error('Time shift parameter error'); end;
if ~exist('smin','var'),  smin = 40; end;
LINE_LEN = 15;

% Prepare directory to save binary files
new_bin_dir=new_meg_file(1:strfind(new_meg_file,'.meg.mat')-1);
if exist(new_bin_dir, 'dir') ~= 7
    vb_mkdir(new_bin_dir);
end

% Load MEG channel information
ch_labels = vb_megfile_get_channel_label_meg(meg_file);
ch_len = size(ch_labels,1);
meg_info  = vb_load_measurement_info(meg_file);
precision = vb_meginfo_get_precision(meg_info);

% Calculate temporal PCA of reference sensor data
Twin=Twin_sec*meg_info.SampleFreq;
loadspec_ref.ChannelType = 'REFERENCE';
ref = vb_load_meg_data(meg_file,loadspec_ref);
[zref,tx] = vb_temporal_pca(ref, Twin, smin);

% Start denoising
fprintf('Start denoising using reference sensor\n')
for i_ch=1:ch_len
    fprintf('[%s]', ch_labels{i_ch});
    if ~rem(i_ch, LINE_LEN), fprintf('\n'); end
    
    load_spec.ChannelName = {ch_labels{i_ch}};
    load_spec.ChannelSwitch = true; % ChannelName is to read
    load_spec.ChannelType = 'MEG';
    load_spec.ActiveChannel = 0; % all channels
    
    % Denoise
    meg = vb_load_meg_data(meg_file, load_spec);
    denoised_meg=meg;
    denoised_meg(tx) = meg(tx)-(meg(tx)*zref')*zref;
    
    % Save denoised data
    new_file = sprintf('%s/%s.ch.meg.dat', new_bin_dir, ch_labels{i_ch});
    fid = fopen(new_file, 'wb');
    if fid == -1
        warning('(%s) cannot open file : %s\n', mfilename, new_file);
        continue;
    end
    fwrite(fid, denoised_meg, precision);
    fclose(fid);
end

% Copy and paste other files
ch_labels_ext = vb_megfile_get_channel_label_extra(meg_file);
ch_labels_ref = vb_megfile_get_channel_label_refmg(meg_file);
ch_labels_extra = [ch_labels_ext; ch_labels_ref];
ch_len_extra = size(ch_labels_extra, 1);

for i_ch = 1:ch_len_extra
    load_spec.ChannelName = {ch_labels_extra{i_ch}};
    load_spec.ChannelSwitch = true; % ChannelName is to read
    load_spec.ChannelType = 'ALL';
    load_spec.ActiveChannel = 0; % all channels
    
    % Do nothing
    meg = vb_load_meg_data(meg_file, load_spec);
    
    % Save data
    new_file = sprintf('%s/%s.ch.meg.dat', new_bin_dir, ch_labels_extra{i_ch});
    fid = fopen(new_file, 'wb');
    if fid == -1
        warining('(%s) cannot open file : %s\n', mfilename, new_file);
        continue;
    end
    fwrite(fid, meg, precision);
    fclose(fid);
end

load(meg_file)
a=strfind(new_bin_dir,'/');
MEGinfo.saveman.data_dir = ['.' new_bin_dir(a(end):end)];
bexp         = [];
bexp_ext     = [];
refmg        = [];
fprintf('\n');
fprintf('save: %s\n',new_meg_file);
vb_fsave(new_meg_file, 'MEGinfo','bexp','bexp_ext','refmg', ...
  'CoordType','Measurement','PositionFile',...
  'Qpick','pick','ref_Qpick','ref_pick');
