function vb_actfile_combine_key(actfile,act_key1,act_key2,act_key3,mode)
% Combine activities and register into activity file (.act.mat)
%
% --- Syntax
% function vb_actfile_combine_key(actfile,act_key1,act_key2,act_key3,mode)
%
% --- Input
% actfile : Activity file (.act.mat)
% act_key1: Activity map key to be combined
% act_key2: Activity map key to be combined
% act_key3: Activity map key for combined data
%
% --- Input (optional)
% mode: (default: 'max')
%  mode = 'max': take maximal activity value at each vertex.
%  mode = 'avr': take average of the two activity values at each vertex.
%
% --- Example
% >> actfile = 'sample.act.mat';
% >> act_key1 = 'act1';
% >> act_key2 = 'act2'; 
% >> act_key3 = 'act1_and_act2';
% >> vb_actfile_combine_key(actfile,act_key1,act_key2,act_key3);
%
% --- History
% 2008-07-16 Taku Yoshioka
% 2010-01-26 (Sako) renamed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Default parameters
if nargin<5 || isempty(mode), mode = 'max'; end

% Load activity maps
act1 = vb_get_act(actfile,act_key1);
act2 = vb_get_act(actfile,act_key2);

% Combine data
switch mode
 case 'max',
  act_new.xxP = (max([act1.xxP'; act2.xxP']))';
 case 'avr',
  act_new.xxP = (mean([act1.xxP'; act2.xxP']))';
end

act_new.key = act_key3;
act_new.comment = ['This activity map was created from ' act_key1 ...
                   ' and ' act_key2 '.'];

% Registration
vb_add_act(actfile,act_new);

