function	y = vb_online_highpass_cut2(x,Fs,Fcut)
% Highpass cut filter using Online lowpass filter
% filtfilt-like forward-backward filtering
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch,T] = size(x);

% Initialize lowpass filter
[a, z] = vb_lowpass_init(Fs,Fcut,Nch);

% Calculate initial value for lowpass component from initial signal
T0 = Fs/Fcut; % one cycle length
for t=1:T0
	z = vb_online_lowpass(a,x(:, t),z);
end

y = zeros(Nch,T);

% Online highpass filtering by subtracting lowpass component from signal
for t=1:T
	[y(:,t), z] = vb_online_highpass(a, x(:, t), z);
end

z0 = z;
yz = zeros(Nch,T0);

% one cycle forward
for t=1:T0
	[yz(:,t), z] = vb_online_highpass(a, z0, z);
end
% one cycle backward
for t=T0:-1:1
	[yt, z] = vb_online_highpass(a, yz(:,t), z);
end

xy = y;
% backward filtering
for t=T:-1:1
	[y(:,t), z] = vb_online_highpass(a, xy(:, t), z);
end

