function	y = vb_online_highpass_cut(x,Fs,Fc,init_mode)
% Highpass cut filter using Online lowpass filter
%   y = vb_online_highpass_cut(x,Fs,Fc)
%   y = vb_online_highpass_cut(x,Fs,Fc,init_mode)
% --- Input
% Fs : Sampling frequencies (Hz)
% Fc : Center frequencies (Hz) for lowpass filter
% x  : Input signal [D x T]
% --- Optional Input
% if init_mode = 1, 
% initial value of lowpass state variable is Initialized 
% by first one cycle (= Fs/Fc) data 
% --- Output
% y  : output signal by online highpass filter [D x T]
%
% 2009-6-20 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch,T] = size(x);

% Initialize lowpass filter
[a, z] = vb_lowpass_init(Fs,Fc,Nch);

if nargin == 4 && init_mode == 1
	T0 = min( ceil(Fs/Fc) , T); % one cycle length
	
	% Calculate initial value for lowpass component from initial signal
	[y0, z] = vb_online_lowpass_filt(a(1), x(:,T0:-1:1), z);
end

[y , z] = vb_online_highpass_filt(a(1), x, z);

return

[Nch,T] = size(x);

% Calculate initial value for lowpass component from initial signal
for t=1:T0
	z = vb_online_lowpass(a,x(:, t),z);
end

y = zeros(Nch,T);

% Online highpass filtering by subtracting lowpass component from signal
for t=1:T
	[y(:,t), z] = vb_online_highpass(a, x(:, t), z);
end
