function [eeginfo] = vb_eeginfo_set_reference(eeginfo, reference)
% set reference type to EEGinfo
% [usage]
%   [eeginfo] = vb_eeginfo_set_reference(eeginfo, reference)
% [input]
%     eeginfo : <required> <<struct>> EEGinfo
%   reference : <optional> <<string>> reference type []
% [output]
%     eeginfo : updated EEGinfo
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('reference', 'var'), reference = ''; end
[eeginfo, reference] = inner_check_arguments(eeginfo, reference);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo.device_info.Reference = reference;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, reference] = inner_check_arguments(eeginfo, reference)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s) eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
