function [eeginfo] = vb_eeginfo_set_rectime(eeginfo, rec_time)
% set record time to EEGinfo
% [usage]
%   [eeginfo] = vb_eeginfo_set_rectime(eeginfo, rec_time)
% [input]
%    eeginfo : <required> <<struct>> EEGinfo
%   rec_time : <optional> <<string>> record time [] [sec]
% [output]
%    eeginfo : updated EEGinfo
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('rec_time', 'var'), rec_time = ''; end
[eeginfo, rec_time] = inner_check_arguments(eeginfo, rec_time);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo.device_info.RecordTime = rec_time;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, rec_time] = inner_check_arguments(eeginfo, rec_time)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s) eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
