function  [idx, label] = vb_eeginfo_get_trigger_status_label(EEGinfo, trans)
% recognize trigger and status channel by label of transducer
% [usage]
%   [idx, label] = vb_eeginfo_get_trigger_status_label(EEGinfo, trans)
% [input]
%   EEGinfo : <required> current EEGinfo struct
%     trans : <optional> Transduser field of EEGinfo.head (cell array)
%           : ['Triggers and Status']
% [output]
%       idx : indeces of trigger (1 x N)
%     label : trigger channel label (cell array)
% [note]
%   
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('EEGinfo', 'var'), EEGinfo = []; end;
if ~exist('trans', 'var'), trans = []; end;
[EEGinfo, trans] = inner_check_arguments(EEGinfo, trans);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
vb_define_device;

idx = [];
label = [];

transducers = EEGinfo.header.Transducer;
label_base = vb_eeginfo_get_channel_label(EEGinfo);

for nt = 1:size(transducers,2)
  if strcmp(deblank(transducers(nt,:)), trans)
    next_idx = size(label,2) + 1;
    label{next_idx} = label_base{nt};
    idx = [idx,nt];
  end
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [EEGinfo, trans] = inner_check_arguments(EEGinfo, trans)
func_ = mfilename;

vb_define_device;

if isempty(EEGinfo)
  error('(%s)EEGinfo is a required parameter', func_);
end

if isempty(trans)
  trans = {EEG_TRIGGER_CHANNEL};
end
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
