function [freq] = vb_eeginfo_get_sampling_frequency(eeginfo)
% return sampling frequency from EEGinfo struct
%
% [usage]
%   [freq] = vb_eeginfo_get_sampling_frequency(eeginfo)
%
% [input]
%   eeginfo : <required> <<struct>> EEG header information
%
% [output]
%      freq : value of sampling frequency
%
% [note]
%   
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var') eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
freq = eeginfo.SampleFrequency;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end

if ~isfield(eeginfo, 'SampleFrequency')
  eeginfo.SampleFrequency = 0;
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
