function [read_ch] = vb_eeginfo_get_read_channels(eeginfo, ...
  ch_list, read_swt, active_swt)
% return channel list to be read by channel list and read switch
% [usage]
%   [read_ch_list] = vb_eeginfo_get_read_channels(...
%     eeginfo, ch_list, read_swt, active_swt)
% [input]
%      eeginfo : <<struct>> EEGinfo
%      ch_list : [Nchannel x 1] list of channel labels
%     read_swt : <<boolean>> 'ch_list' is to be read or to be omitted?
%              :   true) read
%              :  false) omitted
%   active_swt : <<boolean>> target channels are only active or not
%              :   true) only active
%              :  false) all the channels
% [output]
%      read_ch : channel list to be read
% [note]
%   basically arguments are not be checked
% [history]
%   2008-06-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('active_swt', 'var'), active_swt = []; end
if isempty(active_swt), active_swt = false; end

% ----- "base_list" is filtered by ActiveChannel if prescribed
base_list = [vb_eeginfo_get_channel_label(eeginfo, active_swt); ...
             vb_eeginfo_get_channel_label_extra(eeginfo, active_swt)];

% ----- matching specified channel list and filtered chanel list
read_ch = vb_util_get_labels_to_read(base_list, ch_list, read_swt);
return

%%% END OF FILE %%%
