function [datatype] = vb_eeginfo_get_datatype(eeginfo)
% <<getter>> return data type list from EEGinfo
% [usage]
%   [datatype] = vb_eeginfo_get_datatype(eeginfo)
% [input]
%    eeginfo : <required> <<struct>> EEGinfo
% [output]
%   datatype : data type list [Nx1]
% [note]
% 
% [history]
%   2008-02-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'DataType')
  datatype = [];
else
  datatype = eeginfo.DataType;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
