function [ch_idx, result] = vb_eeginfo_get_channel_index(eeginfo, active_swt)
% return channel index list
% [usage]
%   ch_idx = vb_eeginfo_get_channel_index(eeginfo, active_swt)
% [input]
%      eeginfo : <required> <<struct>> EEGinfo
%   active_swt : <optional> <<boolean>> active filter switch [false]
% [output]
%       ch_idx : [Nch x 1] channel index list
%       result : <<integer>> error code
%              :   0) success
%              :   1) error - bad eeginfo
% [note]
%   channel index is kept in .ChannelID field of EEGinfo
% [history]
%   2008-04-16 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[eeginfo, active_swt, result] = inner_check_arguments(eeginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if result ~= 0
  ch_idx = [];
  return;
end

if isfield(eeginfo, 'ChannelID')
  ch_idx = eeginfo.ChannelID;
else
  fprintf('(%s)cannot find ChannelID field\n', mfilename);
  result = 1;
  ch_idx = [];
  return;
end

if active_swt
  if ~vb_info_active_channel_is_valid(eeginfo)
    return;
  end
  active_list = vb_info_get_active_channel(eeginfo);
  ch_idx = ch_idx(active_list == 1);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, active_swt, result] = ...
  inner_check_arguments(eeginfo, active_swt)
func_ = mfilename;
result = 0; % success

if isempty(eeginfo)
  fprintf('(%s)eeginfo is a required parameter\n', func_);
  result = 1;
  return;
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
