function [coordtype] = vb_eegfile_load_coordtype(eegfile)
% read coordinate type from EEG-MAT file
% [usage]
%   [coordtype] = vb_eegfile_load_coordtype(eegfile)
% [input]
%   eegfile : <required> <<file>> EEG-MAT file
% [output]
%   coordtype : <<string>> coordinate type e.g. 'SPM_Right_M'
%             :  If EEG-MAT file does not have any appropriate field, 
%             :  return empty.
%             :  If EEG-MAT file is invalid, return 'BAD_EEG_FILE' for now
% [note]
%
% [history]
%   2008-04-01 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eegfile', 'var'), eegfile = ''; end
[eegfile] = inner_check_arguments(eegfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(eegfile)
  coordtype = 'BAD_EEG_FILE';
  return;
end

eeginfo = vb_eegfile_load_eeginfo(eegfile);
if isempty(eeginfo)
  fprintf('(%s)eegfile (%s) does not have eeginfo\n', ...
    mfilename, eegfile);
  coordtype = 'BAD_EEG_FILE';
else
  if isfield(eeginfo, 'CoordType')
    coordtype = eeginfo.CoordType;
  else
    fprintf('(%s)EEG-MAT file (%s) does not have coordinate type field\n', ...
      mfilename, eegfile);
    coordtype = '';
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile] = inner_check_arguments(eegfile)
func_ = mfilename;
if isempty(eegfile)
  fprintf('(%s)eegfile is invalid\n', func_);
  return;
end

if exist(eegfile, 'file') ~= 2
  fprintf('(%s)cannot find eegfile : %s\n', func_, eegfile);
  eegfile = '';
  return;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
