function [sensorpos] = vb_eegfile_get_sensor_position(eegfile, active_swt)
% return coordinates of sensor positions
% [usage]
%   [sensorpos] = vb_eegfile_get_sensor_position(eegfile, active_swt)
% [input]
%      eegfile : <required> <<file>> EEG-MAT file
%   active_swt : <optional> <<boolean>> [false] active filter switch
%              :   true) return only active
%              :  false) return all the channels
% [output]
%   sensorpos : 3D-coordinates of sensor position [Nchannel x 3]
% [note]
%   @see  vb_eeginfo_get_sensor_position  
% [history]
%   2007-07-17 (Sako) initial version
%   2008-04-15 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS
if ~exist('eegfile', 'var'), eegfile = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[eegfile, active_swt] = inner_check_arguments(eegfile, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
EEGinfo = vb_load_measurement_info(eegfile);
[sensorpos] = vb_eeginfo_get_sensor_position(EEGinfo, active_swt);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile, active_swt] = inner_check_arguments(eegfile, active_swt)
func_ = mfilename;
if isempty(eegfile)
  error('(%s)eegfile is a required parameter', func_);
end

if exist(eegfile, 'file') ~= 2
  error('(%s)cannot find eegfile : %s', func_, eegfile);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
