function vb_util_line_trigger(this_x, y_data, line_clr)
% make a vertical line of trigger
% [usage]
%   vb_util_line_trigger(this_x, y_data, line_clr)
% [input]
%     this_x : <required> X value
%     y_data : <required> data set of Y which will be set as 'YData'
%   line_clr : <optional> color of line ['g']
% [output]
%   none
% [note]
% [history]
%   2006-12-22 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vb_define_process_trigger;

% --- CHECK ARGUMENTS --- %
if ~exist('this_x', 'var')     this_x = []; end;
if ~exist('y_data', 'var')     y_data = []; end;
if ~exist('line_clr', 'var') line_clr = []; end;
[this_x, y_data, line_clr] = inner_check_arguments(this_x, y_data, line_clr);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
trigger_label = sprintf('%d', this_x);

y_max = max(y_data);
th = text(this_x, inner_label_y(y_max) , trigger_label);
set(th, 'Tag', DPT_TRIGGERTEXT_TAG);
if vb_matlab_version('>=', '6.5')
  set(th,'BackgroundColor','y');
end

x_data = this_x .* ones(size(y_data));
line_h = line('XData', x_data, 'YData', y_data, ...
  'Color',     line_clr, ...
  'Tag',       DPT_TRIGGERLINE_TAG, ...
  'LineStyle', '-'); hold on;
set(line_h, 'UserData',  [line_h th]);
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [this_x, y_data, line_clr] = ...
  inner_check_arguments(this_x, y_data, line_clr)

if isempty(this_x) error('this_x is a required parameter'); end;
if isempty(y_data) error('y_data is a required parameter'); end;

if isempty(line_clr) line_clr = 'g'; end;
%
% --- end of inner_check_arguments()
    
% --- inner_label_y()
%
function label_y = inner_label_y(y_max)
THIS_INFLATION = 500;
label_y = y_max + THIS_INFLATION;
return;
%
% --- end of inner_label_y()

%%% END OF FILE %%%
