function vb_cb_clip_trigger(state)
% clip trigger as a callback function of vb_do_mark_trigger
% [usage]
%   vb_cb_clip_trigger(state)
% [input]
%   state : program handle label
%         :  'down' or 'move' or 'up'
%         :  'mode' or 'prev' or 'restore' or 'save'
% [output]
%   none
% [note]
%   [CALLBACK]
%   This function is only expected to be called as callback.
%   @see vb_do_mark_trigger
%   @see vb_util_line_trigger
%   @see vb_define_process_trigger;
%   <<struct>> x_range
%       begin : beginning value
%         end : ending value
% [history]
%   2007-01-25 (Sako) prototype #2 - added zoom function
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% common definition
vb_define_process_trigger;

VERBOSE = true;

if ~exist('state', 'var')
  state = [];
end

% --- initialize --- %
trigger_line_gap = 10;
trigger_line_clr = 'g';

htype = get(gco,'Type');
tag = get(gco,'Tag');
marker = getappdata(gcf,'Marker');
color  = getappdata(gcf,'Color');

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(state)
  if VERBOSE fprintf('no state\n'); end;
  return;
end

% fprintf('  --- state [ %s ]\n', state);

switch  state


  % --- MOUSE EVENT ---------------------------------------------------------- %
  %
  % --- down
  %
  case  'down'
  % Execute the WindowButtonDownFcn

    if VERBOSE fprintf( ...
      '[callback] state:%s, htype:%s, tag:%s\n', state, htype, tag); end;

    ud = get(gcf, 'UserData');
    cp = get(gca, 'CurrentPoint');
    x = cp(1,1);       %first xy values
    y = cp(1,2);       %first xy values

    if inner_is_select_switch_on
      % do nothing
      return;
      
    elseif strcmp(tag, DPT_TRIGGERLINE_TAG)

      % --- DELETE LINE --- %
      inner_delete_line(VERBOSE);

    else
      % --- DRAW LINE --- %
      inner_draw_line(trigger_line_gap, trigger_line_clr, x, VERBOSE);
    end


  % --- move
  %
  case  'move'

    % Execute the WindowButtonMotionFcn
    ud = get(gcf, 'UserData');
    if ud.drag_switch == false
      return;
    end

    % test
    select_xrange('move', gca);
  %   if VERBOSE fprintf('[callback] state : move - do nothing\n'); end;

  
  % --- up
  %
  case  'up'
  % if VERBOSE fprintf('[callback] state : %s\n', state); end;

    % do nothing
    return;
  %
  % --- END OF MOUSE EVENT --------------------------------------------------- %


  % --- CONTROL BUTTON EVENT ------------------------------------------------- %
  %
  % --- mode
  %
  case  'mode'
    if VERBOSE, fprintf('[callback] state : %s\n', state); end;
    inner_switch_mode(VERBOSE);
  

  % --- zoonin
  %
  case  'zoomin'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    if inner_is_select_switch_on
      ud = get(gcf, 'UserData');
      xlim = get(gca, 'XLim');
%       ud.previous_x_begin = xlim(1);
%       ud.previous_x_end = xlim(2);
      ud.axis_ends = ...
        vb_axisends_set(ud.axis_ends, 'PREVIOUS', 'X', xlim(1), xlim(2));
      set(gcf, 'UserData', ud);

      x_data = select_xrange('get', gca);
      x_range.begin = x_data(1);
      x_range.end   = x_data(2);
      inner_zoom(x_range, [], true);
    end


  % --- previous
  %
  case  'prev'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    ud = get(gcf, 'UserData');
%     x_range.begin = ud.previous_x_begin;
%     x_range.end = ud.previous_x_end;
    [x_range.begin, x_range.end] = vb_axisends_get(ud.axis_ends, 'PREVIOUS', 'X');
    [y_range.begin, y_range.end] = vb_axisends_get(ud.axis_ends, 'PREVIOUS', 'Y');
    inner_zoom(x_range, y_range, VERBOSE);

    
  % --- restore (initial size)
  %
  case  'restore'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    ud = get(gcf, 'UserData');
%     x_range.begin = ud.org_begin_x;
%     x_range.end = ud.org_end_x;
    [x_range.begin, x_range.end] = vb_axisends_get(ud.axis_ends, 'ORIGINAL', 'X');
    [y_range.begin, y_range.end] = vb_axisends_get(ud.axis_ends, 'ORIGINAL', 'Y');
    inner_zoom(x_range, y_range, VERBOSE);

  
  % --- save
  %
  case  'save'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    [FileName,PathName,FilterIndex] = uiputfile( ...
      '*.mat', DPT_TITLE_FILE_SELECTOR);

    if FileName == 0 return; end
    if PathName == 0 return; end
    
    ud = get(gcf, 'UserData');
    ud.output_file = [PathName FileName];
    set(gcf, 'UserData', ud);

    % --- SAVE --- %
    inner_save(VERBOSE);

  
  % --- zoom_slide_x
  %
  case  'zoom_slide_x'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;

%     if inner_is_select_switch_on
    ud = get(gcf, 'UserData');
%     xlim = get(gca, 'XLim');
%     ud.previous_x_begin = xlim(1);
%     ud.previous_x_end   = xlim(2);
%     set(gcf, 'UserData', ud);

    value = get(gco,'Value');
%     fprintf('slider value = %d\n', value);

%     base_begin = ud.slider_base_begin_x;
%     base_end   = ud.slider_base_end_x;
    [base.begin, base.end] = vb_axisends_get(ud.axis_ends, 'SLIDER', 'X');

    new_begin = base.begin;    % no change
    
    current_dist = base.end - base.begin;
    retreat_dist = current_dist * value / (MAX_ZOOM_RANGE+1);
    new_end = base.end - retreat_dist;

    x_range.begin = new_begin;
    x_range.end   = new_end;
    fprintf('xrange.[begin,end] = [%f,%f]\n', x_range.begin, x_range.end);
    inner_slider_zoom(x_range, 'X', true);
%     end
  return;

  
  % --- zoom_slide_y
  %
  case  'zoom_slide_y'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;

    value = get(gco,'Value');

    ud = get(gcf, 'UserData');
%     base_begin = ud.slider_base_begin_y;
%     base_end   = ud.slider_base_end_y;
    [base.begin, base.end] = vb_axisends_get(ud.axis_ends, 'SLIDER', 'Y');

    new_begin = base.begin;    % no change
    
    current_dist = base.end - base.begin;
    retreat_dist = current_dist * value / (MAX_ZOOM_RANGE+1);
    new_end = base.end - retreat_dist;

    y_range.begin = new_begin;
    y_range.end   = new_end;
    fprintf('y_range.[begin,end] = [%f,%f]\n', y_range.begin, y_range.end);
    inner_slider_zoom(y_range, 'Y', true);
    return;
    

  % --- move_slide_y
  %
  case  'move_slide_y'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    [new_begin, new_end] = inner_calc_movement('Y');

    y_range.begin = new_begin;
    y_range.end   = new_end;
    fprintf('y_range.[begin,end] = [%f,%f]\n', y_range.begin, y_range.end);
    inner_slider_zoom(y_range, 'Y', true);
    return;
    
  % --- aux_1
  %
  case 'aux_1'
    if VERBOSE fprintf('[callback] state : %s\n', state); end;
    inner_aux1(VERBOSE);
  %
  % --- END OF CONTROL BUTTON EVENT ------------------------------------------- %

  otherwise
    warning('unimplemented state : %s', state);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_zoom()
%
% prior conditions
%   : all arguments must be required.
%   : x_range and y_range are allowable to be empty
function inner_zoom(x_range, y_range, VERBOSE)

  vb_define_process_trigger;

  % --- get user data
  %
  ud = get(gcf, 'UserData');

  % --- set both ends of X-axis and Y-axis
  %
  x_slider_reset = true;
  y_slider_reset = true;

  xlim = get(gca, 'XLim');
  ylim = get(gca, 'YLim');

  if isempty(x_range)
    x_slider_reset = false;
    x_range.begin = xlim(1);
    x_range.end   = xlim(2);
  end

  if isempty(y_range)
    y_slider_reset = false;
    y_range.begin = ylim(1);
    y_range.end   = ylim(2);
  end

  % update previous data
  ud.axis_ends = vb_axisends_set(ud.axis_ends, 'PREVIOUS', 'X', xlim(1), xlim(2));
  ud.axis_ends = vb_axisends_set(ud.axis_ends, 'PREVIOUS', 'Y', ylim(1), ylim(2));

  [begin_x, end_x] = inner_get_real_begin_end(x_range);
  set(gca, 'XLim', [begin_x, end_x]);

  [begin_y, end_y] = inner_get_real_begin_end(y_range);
  set(gca, 'YLim', [begin_y, end_y]);


  % --- reset zoom slider
  %
  if x_slider_reset

    sld_zoom_x = findobj(gcf, 'Tag', DPT_CTRL_TAG_ZOOM_X);
    set(sld_zoom_x, 'Value', 1);

    ud.axis_ends = vb_axisends_set(ud.axis_ends, 'SLIDER', 'X', begin_x, end_x);
    fprintf('X_zoom[begin,end] = [%f,%f]\n', begin_x, end_x);
  end

  if y_slider_reset
    sld_zoom_y = findobj(gcf, 'Tag', DPT_CTRL_TAG_ZOOM_Y);
    set(sld_zoom_y, 'Value', 1);

    sld_move_y = findobj(gcf, 'Tag', DPT_CTRL_TAG_MOVE_Y);
    set(sld_move_y, 'Value', 0);

    ud.axis_ends = vb_axisends_set(ud.axis_ends, 'SLIDER', 'Y', begin_y, end_y);
    fprintf('Y_zoom[begin,end] = [%f,%f]\n', begin_y, end_y);
  end

  % --- update UserData
  %
  set(gcf, 'UserData', ud);
  
  % --- clear selected region
  %
  inner_reset_selected_region;
%
% --- end of inner_zoom()


% --- inner_slider_zoom()
%
function inner_slider_zoom(range, tag, VERBOSE)

  [new_begin, new_end] = inner_get_real_begin_end(range);

  % --- get user data
  %
  ud = get(gcf, 'UserData');

  % --- update previous data
  %
  xlim = get(gca, 'XLim');
  ylim = get(gca, 'YLim');

  ud.axis_ends = vb_axisends_set(ud.axis_ends, 'PREVIOUS', 'X', xlim(1), xlim(2));
  ud.axis_ends = vb_axisends_set(ud.axis_ends, 'PREVIOUS', 'Y', ylim(1), ylim(2));

  % actually move here
  axis_tag = upper(tag);
  if strcmp(axis_tag, 'Y')
    set(gca, 'YLim', [new_begin, new_end]);
  else
    set(gca, 'XLim', [new_begin, new_end]);
  end

  % --- update UserData
  %
  set(gcf, 'UserData', ud);

  % --- clear selected region
  %
  inner_reset_selected_region;

  if VERBOSE, ...
      fprintf('slider: [begin,end] = [%f,%f]\n', new_begin, new_end); end;
%
% --- end of inner_slider_zoom()


% --- inner_switch_mode()
%
function inner_switch_mode(VERBOSE)

  vb_define_process_trigger;
  
  ud = get(gcf, 'UserData');
  if isfield(ud, 'drag_switch')
    if ud.drag_switch
      ud.drag_switch = false;
    else
      ud.drag_switch = true;
    end;
  else
    ud.drag_switch = true;
  end

  if ud.drag_switch == true
    mode_str = DPT_LBL_MODE_RANGE;
  else
    mode_str = DPT_LBL_MODE_LINE;
  end

  set(gco, 'String', mode_str);
  set(gcf, 'UserData', ud);
%
% --- end of inner_switch_mode()


% --- inner_save()
%
function inner_save(VERBOSE)

  vb_define_process_trigger;

  if VERBOSE fprintf('  === gather trigger points ===\n'); end;

  trigger_sample_list = [];
    
  actors_h = get(gca, 'Children');
  for n = 1:size(actors_h,1)
    actor_tag = get(actors_h(n), 'Tag');
    if strcmp(DPT_TRIGGERTEXT_TAG, actor_tag)
      sample_value = get(actors_h(n), 'String');
      if VERBOSE fprintf('>>> label tag! : (%d,%s)\n', n, sample_value); end;
      trigger_sample_list = [trigger_sample_list str2num(sample_value)];
    end
  end
  trigger_sample_list = sort(trigger_sample_list)';
    
  % save data
  ud = get(gcf, 'UserData');

  trigger_list_file = ud.output_file;
  vb_save(trigger_list_file, 'trigger_sample_list');

  if VERBOSE fprintf( ...
    '  === save trigger information : %s\n', trigger_list_file); end;
%
% --- end of inner_save()


% --- inner_delete_line()
%
function inner_delete_line(VERBOSE)
  if VERBOSE fprintf('  === delete trigger line\n'); end;
  ud = get(gco, 'UserData');
  line_h = ud(1);
  label_h = ud(2);
  delete(label_h);
  delete(line_h);
%
% --- end of inner_delete_line()

% --- inner_draw_line()
%
function inner_draw_line( ...
  trigger_line_gap, trigger_line_clr, round_x, VERBOSE)

  y_limit = get(gca, 'YLim');
  y_min = y_limit(1);
  y_max = y_limit(2);

  y_data = [y_min:trigger_line_gap:y_max];

  vb_util_line_trigger(round_x, y_data, trigger_line_clr);
%
% --- end of inner_draw_line()

% --- inner_aux1()
%
function inner_aux1(VERBOSE)
% for test
  % do nothing
  return;
%
% --- end of inner_aux1()


% --- inner_select_switch_on()
%
function [result] = inner_is_select_switch_on
  ud = get(gcf, 'UserData');
  result = ud.drag_switch;
%
% --- end of inner_select_switch_on()


% --- inner_get_real_begin_end()
%
function  [my_begin, my_end] = inner_get_real_begin_end(both_ends)
  if both_ends.begin > both_ends.end
    my_begin = both_ends.end;
    my_end = both_ends.begin;
  else
    my_begin = both_ends.begin;
    my_end = both_ends.end;
  end
%
% --- end of inner_get_real_begin_end()


% --- inner_calc_movement()
%
function [new_begin, new_end] = inner_calc_movement(xy_tag);

  vb_define_process_trigger;

  XY_TAG = upper(xy_tag);

  value = get(gco,'Value');

  % buffer size
  ud = get(gcf, 'UserData');

  if strcmp(XY_TAG, 'Y')
    lim = get(gca, 'YLim');
  else % X
    lim = get(gca, 'XLim');
  end

  [base.begin, base.end] = vb_axisends_get(ud.axis_ends, 'SLIDER', XY_TAG);

  % view size of Y
  view.begin = lim(1);
  view.end   = lim(2);

  view_dist = abs(view.end - view.begin);
  fprintf('before_move: [begin,end] = [%f,%f]\n', view.begin, view.end);

  move_dist = abs(base.end - base.begin) * value / MAX_ZOOM_RANGE;
  new_begin = base.begin + move_dist;
  new_end   = new_begin + view_dist;
  return;
%
% --- end of inner_calc_movement()


% --- inner_reset_selected_region()
%
function inner_reset_selected_region
  select_xrange('clear', gca);
  select_xrange('init', gca);
%
% --- end of inner_reset_selected_region()

%%% END OF FILE %%%
