function result = vb_bitand_ex(num1, num2, bit_len)
% An enhanced version of 'logical AND' function 'bitand'.
% The new one can accept negative number.
% [usage]
%   result = vb_bitand_ex(num1, num2, bit_len)
% [input]
%      num1 : number #1 [1 x N]
%      num2 : number #2 [1 x N] or [x1]
%   bit_len : length of bit
% [output]
%    result : result of logical AND (base-10)
% [note]
%   convert negative to positive and use 'bitand'
% [history]
%   2007-01-09 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if any(num1 < 0)
  num1 = inner_convert_negative2positive(num1, bit_len);
end

if any(num2 < 0)
  num2 = inner_convert_negative2positive(num2, bit_len);
end

result = bitand(num1,num2);

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_convert_negative2positive()
%
function p_num = inner_convert_negative2positive(n_num, bit_len)

len_num = length(n_num);
p_num = zeros(1,len_num);
for i_num = 1:len_num
  if n_num(i_num) >= 0
    p_num(i_num) = n_num(i_num);
  else
    p_num(i_num) = n_num(i_num) + 2^bit_len;
  end
end

% p_num = n_num + 2^bit_len;
%
% --- end of inner_convert_negative2positive()

%%% END OF FILE %%%
