function	[ymax, ystd] = vb_get_max_std_ratio(data)
% Estimate mean amplitude by using histgram for outlier exclusion
% and calculate amplitude/mean ratio to find bad channel & trials
% amplitude/mean ratio using Median can be also calculated
%   [xmax, xstd] = vb_get_max_std_ratio(X)
% X(t,n) : signal at time t & n-th trial
% xstd   : mean amplitude excluding outlier
% xmax(n): max amplitude for each trial
%        = max_t (abs(X(t,n))) 
% 
% 2009-08-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[T, Ntry] = size(data);

pmin = 0.05;
pmax = 1 - pmin;

yamp = abs(data);
% Max of each trial
ymax = max(yamp,[],1); % [1 x Ntry]

% exclude outlier
y = sort(yamp(:));
y = y(1:fix(T*Ntry*pmax));

ystd = sqrt(mean(y.^2));

%% Histgram
% Nbin = 200;
% [h , y] = hist(yamp(:),Nbin);
%% probability dencity
% p = h/sum(h);
%% cumurative probability
% psum = cumsum(p);
%% limit the range of mean calculation (exclude outlier)
% imax = find(psum > pmax, 1);
% jx = find(yamp(:) <= y(imax));
% ystd = sqrt(mean(yamp(jx).^2));
%

return
%%% END %%%
