function	indx = vb_get_label_index(label,label_list)
% get index of label corresponding to label_list
%  indx = vb_get_label_index(label,label_list)
% label      : label list (cell array)
% label_list : reference label list (cell array)
% if indx(n)==0, there is no corresponding name in 'label_list'
% otherwise, label{n} = label_list{indx(n)}
%
% 2008-3-18 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

N = length(label);

indx = zeros(N,1);

for n=1:N
	j = strmatch(label{n},label_list,'exact');
	if ~isempty(j),	indx(n) = j(1); end;
end
