function	[ix_try,flg] = vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val,num)
% find bad channel & bad trials with large max_ratio
%  [ix_try] = vb_find_bad_trial(ratio1,ratio2, ch_act, thred_val)
% ratio1,ratio2 : max ratio : large value indicates bad channel & bad trials
% thred_val : threshold value
% ch_act : list of good channel
% ix_try : list of bad trials
% 
% 2008-6-1 Masa-aki Sato
% 2009-1-9 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%if length(thred_val)==1, thred_val = [thred_val, 150, 5]; end;
%if length(thred_val)==2, thred_val = [thred_val, 5]; end;

switch	length(thred_val)
case	1
	% bad channel/trial with large max_ratio
	flg = (ratio1(ch_act,:) > thred_val(1)) ...
	    | (ratio2(ch_act,:) > thred_val(1)) ;
case	2
	% bad channel/trial with large max_ratio
	flg = (ratio1(ch_act,:) > thred_val(1)) ...
	    | (ratio2(ch_act,:) > thred_val(2)) ;
case	3
	% bad channel/trial with large max_ratio
	flg = (ratio1(ch_act,:) > thred_val(1)) ...
	    | (ratio2(ch_act,:) > thred_val(2)) ...
	    | (ratio1(ch_act,:) < thred_val(3));
end

% Bad trial with large max_ratio after removing bad channel
if nargin == 5
	ix_try = find( sum(flg, 1) >= num);
else
	ix_try = find( sum(flg, 1) > 0);
end

return
%%% END %%%
