function [saveman] = vb_saveman_set_precision(saveman, prec)
% sets precision field of saveman and returns the updated saveman
% [usage]
%   [saveman] = vb_saveman_set_precision(saveman, prec)
% [input]
%   saveman : <required> <<struct>> depot ship of 'dtype'
%      prec : <optional> <<string>> precision ['']
%           :  e.g. 'float32' or 'float64' etc.
%           :  must be match with 'PRECISION' argument of fread
% [output]
%   saveman : the newly updated saveman struct
% [note]
%   this function does not check correctness
%   this function does not automatically set default value
% [history]
%   2007-06-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('saveman', 'var'), saveman = []; end
if ~exist('prec', 'var'), prec = ''; end
[saveman, prec] = inner_check_arguments(saveman, prec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
saveman.precision = prec;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [saveman, prec] = inner_check_arguments(saveman, prec)

func_ = 'vb_saveman_set_precision';

if isempty(saveman)
  error('(%s)saveman is a required parameter', func_);
end

if ~ischar(prec)
  error('(%s)precision must be <<string>> like ''float64''', func_);
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
