function [swt] = vb_saveman_get_switch(saveman)
% return switch ON (true) or OFF (false) to save
% [usage]
%   [swt] = vb_saveman_get_switch(saveman)
% [input]
%   saveman : <optional> <<struct>> specifications for saving
%           : if this is empty, switch is OFF
% [output]
%       swt : whether save or not (true or false)
% [note]
%   if there is not switch field, determine 'ON' for now
% [history]
%   2007-05-17 (Sako) initial version
%   2011-07-06 (Sako) added empty check
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('saveman', 'var') || isempty(saveman)
  swt = false;
  return;
end
  
if isfield(saveman, 'switch')
  swt = saveman.switch;
else
  if isfield(saveman, 'data_dir')
    % if saveman does not have switch field, regard switch as ON
    swt = true;
  else
    swt = false;
  end
end
return;

% --- END OF FILE --- %
