function  vb_posfile_maker(facefile, old_data_dir, mode)
% Make POS-MAT file from old positioning files(.digit.mat, megpos.mat).
% [usage]
%    vb_posfile_maker(<facefile>, <old_data_dir> [,mode])
% [input]
%       facefile : FACE-MAT file(to get spherical model).
%   old_data_dir : MEG : directory including old positioning(.megpos.mat) files.
%                  EEG : directory including old positioning(.digit.mat) files.
%           mode : [optional] making mode [1] | 2
%                   :  1) MEG (MEGPOS-MAT to POS-MAT)
%                   :  2) EEG (DIGIT-MAT  to POS-MAT)
% [output]
%    none
% [note]
%    old_data_dir/original.megpos.mat ==> old_data_dir/original.pos.mat
%    old_data_dir/original.digit.mat  ==> old_data_dir/original.pos.mat
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('facefile', 'var') || exist(facefile, 'file') ~= 2
    error('facefile is a required parameter.');
end
if ~exist('old_data_dir', 'var') || ~isdir(old_data_dir)
    error('old_data_dir is a required parameter.');
end

%
% --- Main Procedure
%
if ~exist('mode', 'var')
   mode = 1;
end

if mode == 1
    file_ext = '.megpos.mat';
elseif mode == 2
    file_ext = '.digit.mat';
else
    error('Check mode.');
end

% find target files
d = dir([old_data_dir, '/', '*', file_ext]);
file_list = {d.name};
Nfile = length(file_list);
if Nfile == 0
    error([file_ext, ' not found.']);
end

% face file(spherical_head and mri_key)
sph_info = vb_facefile_get_spherical_info(facefile);

% Make 'mri_key'
mri_key = vb_facefile_get_mri_key(facefile);

% Make 'spherical_head'
if ~isempty(sph_info.Center) && ~isempty(sph_info.Radius)
    spherical_info = struct;
    spherical_info.Vcenter = sph_info.Center;
    spherical_info.Vradius = sph_info.Radius;
    spherical_info.coord_type = sph_info.CoordType;
end

% ----- header
header.base_file_name = '';
header.meg_marker_id = 1;
header.file_type = 'POS-MAT';
header.version   = 1.0;

%
% --- Convert old files to new files.
%
def_coord = vb_define_coordinate;
for k=1:Nfile
    if mode == 1 % MEG
        input_file = [old_data_dir, '/', file_list{k}];
        clear trans_mat;
        load(input_file, 'trans_mat');
        trans_info.trans_mri = trans_mat.meg_to_mri;
        trans_info.coord_type_before = 'Unknown';
        trans_info.coord_type_after  = def_coord.COORDINATE_SPM_RIGHT_M;
        coord_type = 'Unknown';
        pos = [];
        name = [];
    else
        input_file = [old_data_dir, '/', file_list{k}];
        clear eeg_sensor digitizer;
        load(input_file, 'eeg_sensor', 'digitizer');
        % .coord_type
        % .pos
        % .name
        % .mri
        % .coord_type_mri
        trans_info.trans_mri = digitizer.trans_mri;
        trans_info.coord_type_before = eeg_sensor.coord_type;
        trans_info.coord_type_after  = eeg_sensor.coord_type_mri;
        coord_type = eeg_sensor.coord_type_mri;
        pos = eeg_sensor.mri;
        name = eeg_sensor.name;
    end

    % make filename(old.megpos(digit).mat ==> old.pos.mat)
    ix = findstr(input_file, file_ext);
    if isempty(ix), error('file name is invalid.'); end
    pos_file_name = [input_file(1:ix-1), '.pos.mat'];

    % --- make file
    var_list = {'mri_key', 'coord_type', 'pos', 'name', 'spherical_info', ...
      'trans_info', 'header'};
    for m=1:length(var_list)
        if exist(var_list{m}, 'var')
            vb_save(pos_file_name, var_list{m});
        end
    end
end

% ---  END OF FILE --- %
