function [pick, Qpick] = vb_megposfile_trans_coord(megposfile, pick, Qpick)
% translate YOKOGAWA coordinates by using transmat information from megposfile
% [usage]
%   [pick, Qpick] = vb_megposfile_trans_coord(megposfile, pick, Qpick)
% [input]
%   megposfile : <required> <<file>> megpos file
%         pick : <required> 3D-coordinates of sensor [N x 3]
%        Qpick : <optional> 3D-coordinates of vector [N x 3] []
% [output]
%    pick : translated pick  [N x 3]
%   Qpick : translated Qpick [N x 3]
% [note]
%   if megposfile is empty, translation is not executed
% [history]
%   2007-07-05 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megposfile', 'var') megposfile = []; end
if ~exist('pick', 'var') pick = []; end
if ~exist('Qpick', 'var') Qpick = []; end
[transmat, pick, Qpick] = inner_check_arguments(megposfile, pick, Qpick);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = 'vb_megposfile_trans_coord';

if isempty(transmat)
  % does not translate
  return;
end

pick  = vb_affine_trans(pick, transmat.meg_to_mri);

if ~isempty(Qpick)
  % only rotate
  Qpick = vb_affine_trans(Qpick, transmat.meg_to_mri, 1);
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [trans_mat, pick, Qpick] = ...
  inner_check_arguments(megposfile, pick, Qpick)
func_ = 'vb_megposfile_trans_coord';

trans_mat = [];

if isempty(megposfile)
  % require no action
else
  if exist(megposfile, 'file') ~= 2
    error('(%s)cannot find megpos file : %s', func_, megposfile);
  end
  
  load(megposfile, 'trans_mat');

  if isempty(trans_mat)
    error('(%s)megpos file does not have trans_mat attribute', func_);
  end
  
  if ~isfield(trans_mat, 'meg_to_mri')
    error('(%s)meg_to_mri is a required field of trans_mat', func_);
  end
end

if isempty(pick)
  error('(%s)pick is a required parameter', func_);
end

if isempty(Qpick)
  % required no action
  % there are some cases that Qpick is not needed
end
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
