function [sph_info] = vb_facefile_get_spherical_info(facefile)
% <<getter>> return center and radius from FACE-MAT file
%
% [usage]
%   [sph_info] = vb_facefile_get_spherical_info(facefile)
%
% [input]
%   facefile : <required> <<file>> FACE-MAT file
%
% [output]
%   sph_info : <<struct>> spherical information as follows
%            :  .Center : center coordinate of spherical head [1x3 double]
%            :  .Radius : radius of spherical head [x1 double]
%            :  .CoordType : coordinate type [x1 string]
%
% [note]
%   
% [history]
%   2008-02-25 (Sako) initial version
%   2008-03-07 (rhayashi) support old and ver1.0 FACE-MAT file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('facefile', 'var'), facefile = []; end
[facefile] = inner_check_arguments(facefile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

face = load(facefile);
if ~isfield(face, 'header')
    version = 0;
else
    version = face.header.version;
end

switch(version)
    case 0
        if isfield(face.subject, 'spherical_head')
            if isfield(face.subject.spherical_head, 'Vcenter')
                center = face.subject.spherical_head.Vcenter;
                radius = face.subject.spherical_head.Vradius;
                coord_type = face.subject.spherical_head.coord_type;
            else
                center = [];
                radius = [];
                coord_type = [];
            end
        end
    otherwise
        if isfield(face, 'spherical_head')
            center = face.spherical_head.Vcenter;
            radius = face.spherical_head.Vradius;
            coord_type = face.coord_type;
        else
            center = [];
            radius = [];
            coord_type = [];
        end
end

sph_info = struct;
sph_info.Center = center;
sph_info.Radius = radius;
sph_info.CoordType = coord_type;

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [facefile] = inner_check_arguments(facefile)
func_ = mfilename;
if isempty(facefile)
  error('(%s)facefile is a required parameter', func_);
end
if exist(facefile, 'file') ~= 2
  error('(%s)cannot find facefile : %s', func_, facefile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
