function define = vb_define_file(define, vbmeg_dir)
% return defined filenames.
% [usage]
%    define = vb_define_file(vbmeg_dir);
% [Input]
%       define : definitions made by other functions.
%    vbmeg_dir : The top directory of VBMEG.
% [Output]
%       define : structure added filenames definition.
% [History]
%    2013-01-24 rhayashi Initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('vbmeg_dir', 'var'), vbmeg_dir = ''; end

define.FILE_MNI_ICBM152_HDR   = fullfile(vbmeg_dir, 'standard_brain/mni_icbm152_t1_tal_nlin_asym_09c.hdr');
define.FILE_MNI_ICBM152_IMG   = strrep(define.FILE_MNI_ICBM152_HDR, '.hdr', '.img');
define.FILE_MNI_ICBM152_BRAIN = fullfile(vbmeg_dir, 'standard_brain', 'mni_icbm152_t1_tal_nlin_asym_09c_20000', 'mni_icbm152_t1_tal_nlin_asym_09c_20000.brain.mat');
define.FILE_MNI_ICBM152_AREA  = strrep(define.FILE_MNI_ICBM152_BRAIN, '.brain.mat', '.area.mat');
define.FILE_MNI_ICBM152_ACT   = strrep(define.FILE_MNI_ICBM152_BRAIN, '.brain.mat', '.act.mat');

define.FILE_MNI_BETMASK_HDR   = fullfile(vbmeg_dir,  'functions/tool_box/atlas2vb_dir/MNI_atlas_templates/betmask.hdr');
define.FILE_MNI_BETMASK_IMG   = strrep(define.FILE_MNI_BETMASK_HDR, '.hdr', '.img');

define.FILE_STD_BRAIN_MASK_MAT = fullfile(vbmeg_dir, 'functions/tool_box/atlas2vb_dir/MNI_atlas_templates/brain_mask.mat');
define.FILE_STD_BRAIN_CORTEX   = fullfile(vbmeg_dir, 'functions/tool_box/atlas2vb_dir/MNI_atlas_templates/ch2_std.brain.mat');
