function vb_util_show_struct(target_struct, rec_flag)
% show all fields of the given struct
% [usage]
%   vb_util_show_struct(target_struct, rec_flag)
% [input]
%   target_struct : <required> <<struct>>
%        rec_flag : <optional> flag to read recursively [1]
%                 :  1) yes
%                 :  0) no
% [output]
%   none
% [note]
% [history]
%   2010-02-03 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK_ARGUMENTS --- %
if ~exist('target_struct', 'var'), target_struct = []; end
if ~exist('rec_flag', 'var'), rec_flag = []; end
[target_struct, rec_flag] = inner_check_arguments(target_struct, rec_flag);

if isempty(target_struct)
  fprintf('!!!EMPTY!!!\n');
  return;
end

if rec_flag == 0
  target_struct
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% target_struct
if ~isstruct(target_struct)
  if isinteger(target_struct)
    fprintf('%d\n', target_struct);

  elseif isfloat(target_struct)
    fprintf('%f\n', target_struct);

  elseif ischar(target_struct)
    fprintf('%s\n', target_struct);

  elseif iscell(target_struct)
    n_elm = length(target_struct);
    for i_elm = 1:n_elm
      fprintf('''%s''\n', target_struct{i_elm});
    end
  else
    fprintf('--- UNEXPECTED TYPE\n');
  end
  return;
end

fields = fieldnames(target_struct);
n_field = length(fields);
for i_field = 1:n_field
%   vb_util_show_struct(fields{i_field});
  fprintf('\n--- ');
  cmd = sprintf('vb_util_show_struct(target_struct.%s)', fields{i_field}); 
  fprintf('%s ---\n', cmd);
  eval(cmd);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [target_struct, rec_flag] = ...
  inner_check_arguments(target_struct, rec_flag)
func_ = mfilename;
if isempty(target_struct)
%   error('(%s) target_struct is a required parameter', func_);
end

if isempty(rec_flag)
  rec_flag = 1;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
