function vb_util_save_struct_fields(file_name, my_struct)
% save all the fields of struct
% [usage]
%   vb_util_save_struct_fields(filename, my_struct)
% [input]
%   file_name : <required> <<string>> saved file name
%   my_struct : <required> <<struct>> the fields of this will be saved
% [output]
%   none
% [note]
%
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('file_name', 'var'), file_name = ''; end
if ~exist('my_struct', 'var'), my_struct = []; end
[file_name, my_struct] = inner_check_arguments(file_name, my_struct);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
command = sprintf('save %s -struct my_struct', file_name);
fprintf(' --- exec : %s\n', command);
eval(command);
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [file_name, my_struct] = inner_check_arguments(file_name, my_struct)
func_ = mfilename;
if isempty(file_name)
  error('(%s)file_name is a required parameter', func_);
end

if isempty(my_struct)
  error('(%s)my_struct is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
