function [newvec] = vb_util_get_overlapping_vector(vec1, vec2)
% return overlapping data of two vectors
% [usage]
%   [newvec] = vb_util_get_overlapping_vector(vec1, vec2)
% [input]
%     vec1 : <required> vector 1 [N x 1] or [1 x N]
%     vec2 : <required> vector 2 [N x 1] or [1 x N]
% [output]
%   newvec : overlapping vector of two vectors [N x 1]
% [note]
%   mode auto-detect - numeric or string - baseline is vec1
% [history]
%   2007-07-11 (Sako) initial version
%   2008-02-12 (Sako) added mode auto-detect
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('vec1', 'var'), vec1 = []; end
if ~exist('vec2', 'var'), vec2 = []; end
[vec1, vec2, mode] = inner_check_arguments(vec1, vec2);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% vec1 and vec2 is [1 x N]
newvec = [];

if mode == 1
  % numeric vector
  for iv = vec1
    if any(iv == vec2)
      newvec = [newvec; iv];
    end
  end
else
  % string vector
  n_vec1 = length(vec1);
  n_vec2 = length(vec2);
  for i_vec1 = 1:n_vec1
    for i_vec2 = 1:n_vec2
      if strcmp(vec1(i_vec1),vec2(i_vec2))
        newvec = [newvec; vec1(i_vec1)];
        break;
      end
    end
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [vec1, vec2, mode] = inner_check_arguments(vec1, vec2)
func_ = mfilename;

if isempty(vec1)
  error('(%s)vec1 is a required parameter', func_);
end

if isempty(vec2)
  error('(%s)vec2 is a required parameter', func_);
end

% mode check
if isnumeric(vec1)
  mode = 1; % numeric vector
  if ~isnumeric(vec2)
    % try to convert
    tmp_vec2 = vec2;
    n_len = length(vec2);
    vec2 = zeros(n_len, 1);
    for i_data = 1:n_len
      vec2(i_data) = str2double(tmp_vec2(i_data));
    end
  end
else
  mode = 2; % string vector
  if isnumeric(vec2)
    % try to convert
    tmp_vec2 = vec2;
    n_len = length(vec2);
    vec2 = cell(n_len, 1);
    for i_data = 1:n_len
      vec2(i_data) = {num2str(tmp_vec2(i_data))};
    end
  end
end

vec1 = vb_util_arrange_list(vec1,1);
vec2 = vb_util_arrange_list(vec2,1);

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
