function [labels, idx] = ...
  vb_util_get_labels_to_read(base_list, target_list, to_read_swt)
% return labels to read
% (mainly be used in order to decide channel list to read)
% [usage]
%   [labels, idx] = ...
%      vb_util_get_labels_to_read(base_list, target_list, to_read_swt)
% [input]
%     base_list : <required>
%               :   base list of labels that must include "target_list"
%   target_list : <optional>
%               :   target list whose purpose is decided by 'to_read_swt' [[]]
%   to_read_swt : <optional> <<boolean>> switch whether to read or not
%               : [true]) target_list means to be included
%               :  false) target_list means not to be included
% [output]
%        labels : label list to read [N x 1]
%           idx : index of base_list
% [note]
%   <case that empty "labels" is returned>
%     - base_list is not given or is empty
%     - target_list is not given or is empty and to_read_swt is true
%     - target_list is not included in base_list
%     -- would return with warning message
%   @see vb_util_is_included_list
%   @see vb_util_omit_list
% [history]
%   2006-12-18 (Sako) initial version
%   2008-02-27 (Sako) thoroughly revised 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base_list', 'var'), base_list = []; end
if ~exist('target_list', 'var'), target_list = []; end
if ~exist('to_read_swt', 'var'), to_read_swt = []; end

[base_list, to_read_swt, target_list, empty_flg] = ...
  inner_check_arguments(base_list, target_list, to_read_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
labels = [];
idx = [];

if empty_flg, return; end;

if to_read_swt == false
  [labels, idx] = vb_util_omit_list(base_list, target_list);
      
else
  [result, idx] = vb_util_is_included_list(base_list, target_list);
  if ~isempty(idx)
    labels = vb_util_arrange_list(base_list(idx));
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base_list, to_read_swt, target_list, empty_flg] = ...
  inner_check_arguments(base_list, target_list, to_read_swt)
func_ = mfilename;
empty_flg = true;

if isempty(base_list)
  fprintf('(%s)base_list is empty\n', func_);
  return;
end

if isempty(to_read_swt)
  to_read_swt = true;
end

% ----- target list
if isempty(target_list)
  if to_read_swt == true
    fprintf('(%s)Though target_list means ''to read'', it is empty\n', ...
      func_);
    return;
  else
    % target_list is empty and it means not to be included
    target_list = base_list;
    to_read_swt = true;
  end
end
empty_flg = false;
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
