function [diff] = vb_util_diff_lists(baselist, rmlist, type)
% get difference between two lists
% [usage]
%   [diff] = vb_util_diff_lists(baselist, rmlist, type)
% [input]
%   baselist : <required> base list [N x 1] or [1 x N]
%     rmlist : <required> removed list [N x 1] or [1 x N]
%       type : <optional> data type numerical or string
%            :   [0]) numerical
%            :    1 ) string (unimplemented)
% [output]
%       diff : difference between baselist and rmlist
%            : [N x 1]
% [note]
%
% [history]
%   2007-07-03 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('baselist', 'var') baselist = []; end
if ~exist('rmlist', 'var') rmlist = []; end
if ~exist('type', 'var') type = []; end
[baselist, rmlist, type] = inner_check_arguments(baselist, rmlist, type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% diff = setdiff(baselist, rmlist);
diff = [];
for cur_num = baselist
  if isempty(find(cur_num == rmlist(:)))
    diff = [diff;cur_num];
  end
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [baselist, rmlist, type] = ...
  inner_check_arguments(baselist, rmlist, type)

func_ = 'vb_util_diff_lists';

if isempty(baselist)
  error('(%s)baselist is a required parameter', func_);
end

if isempty(rmlist)
  error('(%s)rmlist is a required parameter', func_);
end

% arrange to [1 x N] vector
baselist = vb_util_arrange_list(baselist,1);
rmlist = vb_util_arrange_list(rmlist);

if isempty(type)
  type = 0; % numerical
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %
%%% END OF FILE %%%
