function [new_file] = vb_util_change_extension(org_file, new_ext)
% change extension from the original one to specified one
% [usage]
%   [new_file] = vb_util_change_extension(org_file, new_ext)
% [input]
%   org_file : <required> original file path
%    new_ext : <required> new extension
%            :  e.g. '.aaa.mat' or 'aaa.mat'
% [output]
%   new_file : new file path
% [note]
%   if extension period is lost, this program would add it
% [history]
%   2007-01-29 (Sako) initial version
%   2007-06-22 (Sako) replace fileparts to vb_get_file_parts (for MATLAB7.4.0)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('org_file', 'var'), org_file = ''; end;
if ~exist('new_ext', 'var'), new_ext = ''; end;
[org_file, new_ext] = inner_check_arguments(org_file, new_ext);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
new_file = [];
% [org_path, org_name_tmp, org_ext] = fileparts(org_file);
[org_path, org_name_tmp, org_ext] = vb_get_file_parts(org_file);

if isempty(org_path), org_path = '.'; end;
org_name = vb_util_get_file_body(org_name_tmp);
new_file = [org_path filesep org_name new_ext];
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [org_file, new_ext] = inner_check_arguments(org_file, new_ext)
if isempty(org_file), error('org_file is a required parameter'); end;
if isempty(new_ext), error('new_ext is a required parameter'); end;

% if extension period is lost, add it here
if new_ext(1) ~= '.', new_ext = ['.' new_ext]; end;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
