function    mode = vb_tool_check(ToolName)
% Check whether Matlab has 'ToolName' toolbox
%   mode = 0;   %  'ToolName' toolbox is not installed
%   mode = 1;   %  'ToolName' toolbox is installed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%ToolName = 'Optimization';
%ToolName = 'Compiler';

MATver = ver;

Ntool = length(MATver);
Mtool = [];

for n=1:Ntool
    Mtool = [Mtool MATver(n).Name];
end

if isempty(strfind(Mtool,ToolName))
    mode = 0;   %  'ToolName' toolbox is not installed
else
    mode = 1;   %  'ToolName' toolbox is installed
end
