function [keys] = vb_table_get_keys(tbl)
% get keys in the table.
% [USAGE]
%    [keys] = vb_table_get_keys(tbl);
% [IN]
%    tbl : table data.
% [OUT]
%    keys : key_list  <Nx1 cell>
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tbl', 'var')
    error('tbl is a required parameter.');
end

%
% --- Main Procedure
%
keys = [];
if ~isempty(tbl)
    keys = {tbl.key};
end
