function	z = vb_repmultiply(x,y)
% MEX function to multiply a vector with a matrix without repmat 
% Much faster than using repmat and no need to memory allocation
% --- Usage
% z = vb_repmultiply(x,y)
% x : M x N
% z : M x N
%
% case  y : 1 x N
%  z = x .* repmat(y, [M 1])
%    = x * diag(y)
%  z(m,n) = x(m,n) * y(n)
%
% case  y : M x 1
%  z = x .* repmat(y, [1 N])
%    = diag(y) * x
%  z(m,n) = x(m,n) * y(m)
%
% case  y : 1 x 1
%  z = x * y
%  z(m,n) = x(m,n) * y
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
