function	[pathname, filename] = ...
			vb_get_multi_filename(datadir,searchkey,session_no)
% Get file names for specified directory and search string
% --- Usage
%  [pathname, filename] = vb_get_multi_filename(datadir,searchkey,session_no)
% --- Input
% datadir : data directory name
%    ex.    'D:/data/eeg'
% searchkey : file search string
%    ex.    '*_low_epoch.eeg.mat'
% --- Optional Input
% session_no : session number list 
% --- Output
% pathname : cell array of path for multiple files
%   pathname{n} : n-th eeg file path
% filename : cell array of multiple eeg data file names
%   filename{n} : n-th eeg file name
%
% Masa-aki Sato 2008-08-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

dlist = dir([datadir '/' searchkey]);

Nfile = length(dlist);

if exist('session_no','var') && ~isempty(session_no)
	if max(session_no) > Nfile
		error('session number is larger than file number');
	end
else
	session_no = 1:Nfile;
end

Nsession = length(session_no);
pathname = cell(1,Nsession);
filename = cell(1,Nsession);

for n=1:Nsession
	filename{n} = dlist(session_no(n)).name;
	pathname{n} = [datadir '/' filename{n}];
end
