function h = vb_disp_waitbar(parcent, caption, verbose_level_min)
% Display waitbar.
%
% This function shows a message on the MATLAB console. The message is
% automatically suppressed according to vbmeg_inst.verbose_level. 
%
% [syntax]
% vb_disp_waitbar(parcent, caption, verbose_level_min)
%
% [input]
% parcent          : <<string>> parcentage of progress.(0.1-1)
% verbose_level_min: <optional> <<int or string>> Verbose level of this
%                    message. 
% --- verbose level string (verbose_level_min)
%   'NONE' (=0)      Suppressing all messages 
%   'EMERGENCY' (=1)
%   'WARNING' (=2)
%   'NOTICE' (=3)    VBMEG default value
%   'INFO' (=5)
%   'DEBUG' (=10)    Displaying all messages
% ---
%
% [output]
% h                : waitbar handle.
% 
% [example]
% >> vb_disp_waitbar(parcent, 'caption'); % same with below
% >> vb_disp_waitbar(parcent, 'caption','NOTICE'); % default=NOTICE
% >> vb_disp_waitbar(parcent, 'caption', 3); % 3 is NOTICE
%
% exmaple of message suppression
% >> vb_set_verbose('WARNING'); % making verbose level low
% >> vb_disp_waitbar(parcent, 'caption'); % same with the 1st line but none is shown
%
% [history]
% 2020-02-12 rhayashi
%
% [see also]
%    vb_set_verbose, vb_get_verbose, vb_disp_nonl
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
const = vb_define_verbose;
h = [];

if nargin<3 || isempty(verbose_level_min), 
  verbose_level_min = const.VERBOSE_LEVEL_NOTICE;
end

if ischar(verbose_level_min)
  switch verbose_level_min
   case 'NONE'
    verbose_level_min = 0;
   case 'EMERGENCY'
    verbose_level_min = 1;
   case 'WARNING'
    verbose_level_min = 2;
   case 'NOTICE'
    verbose_level_min = 3;
   case 'INFO'
    verbose_level_min = 5;
   case 'DEBUG'
    verbose_level_min = 10;
   otherwise
    fprintf('Invalid verbose string: %s\n',verbose_level_min);
  end
end

if isempty(vbmeg_inst) || ~isfield(vbmeg_inst,'verbose_level')
  verbose_level = const.VERBOSE_LEVEL_NOTICE;
else
  verbose_level = vbmeg_inst.verbose_level;
end

if verbose_level>=verbose_level_min
  h = waitbar(parcent, caption);
end
