function [MEGinfo,bexp,pick,Qpick,CoilWeight] = ...
    vb_channel_rejection(MEGinfo,bexp,pick,Qpick,reject_channel,CoilWeight)
%
% Reject the selected channels. This is interface function.
%
% [MEGinfo,bexp,pick,Qpick,CoilWeight] = ...
%     vb_channel_rejection(MEGinfo,bexp,pick,Qpick,CoilWeight,reject_channel)
% [IN]
%   MEGinfo : struct with MEG acquisition information
%       .MEGch_id         Active MEG channel index (absolute channel inndex)
%       .sensor_weight  % weight to calculate lead field
%       .Nchannel       % number of active gardiometers
%   bexp(ch,t,trial)       : MEG data (Channel, Time, Trial)
%   pick(ch,          1:3) : position of detector coils.
%       (ch+Nchannel, 1:3) : position of conpensation coils.
%   Qpick(ch,         1:3) : direction of detector coils.
%       (ch+Nchannel, 1:3) : direction of conpensation coils.
%   CoilWeight             : for SBI.
%   reject_channel        : vector of rejected channel number .
%                           absolute channel inndex
% [OUT]
%   MEGinfo : struct with MEG acquisition information after rejection
%       .MEGch_id         Active MEG channel index (absolute channel inndex)
%       .sensor_weight  % weight to calculate lead field
%       .Nchannel       % number of active gardiometers after rejection
%   bexp(ch,t,trial)       : MEG data (Channel, Time, Trial) after rejection
%   pick(ch,          1:3) : position of detector coils.
%       (ch+Nchannel, 1:3) : position of conpensation coils.
%   Qpick(ch,         1:3) : direction of detector coils.
%       (ch+Nchannel, 1:3) : direction of conpensation coils.
%   CoilWeight             : for SBI.
%
% MEG channel index 
% MEGinfo.MEGch_id  : Active MEG channel index (absolute channel inndex)
%   bexp(ch,:)              <-> MEGinfo.MEGch_id(n)
%   pick(ch,          1:3)  <-> MEGinfo.MEGch_id(n)
%       (ch+Nchannel, 1:3)  <-> MEGinfo.MEGch_id(n)
%   Qpick(ch,         1:3)  <-> MEGinfo.MEGch_id(n)
%       (ch+Nchannel, 1:3)  <-> MEGinfo.MEGch_id(n)
%   CoilWeight             
%
%   2006-05-08 Masanori Osako
%   2006-05-14 M. Sato
%   2006-06-19 D. Kawawaki modified based on "yokogawa_channel_rejection".
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isfield(MEGinfo, 'device')
    device = 'SBI';
else
    device = MEGinfo.device;
end

switch (lower(MEGinfo.device))
 case 'sbi'
  [MEGinfo,bexp,pick,Qpick,CoilWeight] = ...
    sbi_channel_rejection(MEGinfo,bexp,pick,Qpick,CoilWeight,reject_channel);
 case 'yokogawa'
  [MEGinfo,bexp,pick,Qpick] = ...
    vb_yokogawa_channel_rejection(MEGinfo,bexp,pick,Qpick,reject_channel);
  CoilWeight = MEGinfo.sensor_weight;
end

return
