function [obj] = vb_stack_push(obj, push_data)
% push to stack
% [USAGE]
%    [obj] = vb_stack_push(<obj>, <pushed_obj>);
% [IN]
%          obj : stack object
%    push_data : push data into stack.
% [OUT]
%    obj : stack object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('push_data', 'var')
    error('push_data is a required parameter.');
end

%
% --- Main Procedure
%
switch(obj.class_type)
    case 'm_stack'
        obj = vb_m_stack_push(obj, push_data);
    case 'f_stack'
        obj = vb_f_stack_push(obj, push_data);
    otherwise
        error('Specified obj is invalid.');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
