function [obj, poped_data] = vb_stack_pop(obj)
% pop from stack
% [USAGE]
%    [obj, poped_data] = vb_stack_pop(<obj>);
% [IN]
%    obj : stack object.
% [OUT]
%           obj : stack object.
%    poped_data : poped data from stack.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
switch(obj.class_type)
    case 'm_stack'
        [obj, poped_data] = vb_m_stack_pop(obj);
    case 'f_stack'
        [obj, poped_data] = vb_f_stack_pop(obj);
    otherwise
        error('Specified obj is invalid.');
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
