function [obj] = vb_stack_new(stack_size, stack_type)
% create stack object
% [USAGE]
%    [obj] = vb_stack_new([stack_size][,stack_type]);
% [IN]
%    stack_size : stack buffer size.(default: unlimit)
%    stack_type : 'M', 'm' : stack buffers on memory.(default)
%                 'F', 'f' : stack buffers on MATLAB-tempfile.
%                            MATLAB-tempfile is created by 
%                            MATLAB command 'temp_name'
%
% [OUT]
%    obj : stack object
%
% Examples:
%
%    data = 'test_data';
%
%    % create stack(stack size=10, Memory stack)
%    stk = vb_stack_new(10, 'M'); 
%
%    % push
%    stk = vb_stack_push(stk, data);
%
%    % pop
%    [stk, pop_data] = vb_stack_pop(stk);
%
%    % destroy stack(Don't forget)
%    vb_stack_delete(stk);
%
% Caution:
%    When you push data exceeding the stack_size, 
%    the oldest data is deleted.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('stack_size', 'var')
    stack_size = inf;
end
if ~exist('stack_type', 'var')
    stack_type = 'm';
end

%
% --- Main Procedure
%
obj = struct;
obj.class_type = 'stack';
obj.stack_size = stack_size;

% create concrete object
switch(lower(stack_type))
    case 'm'
        obj = vb_m_stack_new(obj);
    case 'f'
        obj = vb_f_stack_new(obj);
    otherwise
        error('Specified stack_type is invalid.');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
